/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.Arrays;

public class NibbleOrder
extends DosOrder {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static int[] writeTranslateTable = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
    private static int[] sectorInterleave = new int[]{0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15};
    public int[] readTranslateTable = new int[256];

    public NibbleOrder(ByteArrayImageLayout diskImageManager) {
        super(diskImageManager);
        for (int i = 0; i < writeTranslateTable.length; ++i) {
            this.readTranslateTable[NibbleOrder.writeTranslateTable[i]] = i;
        }
    }

    protected byte[] readTrackData(int track) {
        int trackSize = this.getPhysicalSize() / this.getTracksPerDisk();
        return this.readBytes(track * trackSize, trackSize);
    }

    protected void writeTrackData(int track, byte[] trackData) {
        int trackSize = this.getPhysicalSize() / this.getTracksPerDisk();
        this.writeBytes(track * trackSize, trackData);
    }

    @Override
    public byte[] readSector(int track, int dosSector) throws IllegalArgumentException {
        int sector = sectorInterleave[dosSector];
        byte[] trackData = this.readTrackData(track);
        int offset = 0;
        byte[] addressField = new byte[14];
        boolean found = false;
        for (int attempts = this.getSectorsPerTrack(); !found && attempts >= 0; --attempts) {
            int nextOffset = this.locateField(213, 170, 150, trackData, addressField, offset);
            offset = nextOffset;
            int t = this.decodeOddEven(addressField, 5);
            int s = this.decodeOddEven(addressField, 7);
            found = t == track && s == sector;
        }
        if (!found) {
            throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", sector, track, 1));
        }
        byte[] dataField = new byte[349];
        this.locateField(213, 170, 173, trackData, dataField, offset);
        byte[] buffer = new byte[342];
        int checksum = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int b = AppleUtil.getUnsignedByte(dataField[i + 3]);
            checksum ^= this.readTranslateTable[b];
            if (i < 86) {
                buffer[buffer.length - i - 1] = (byte)checksum;
                continue;
            }
            buffer[i - 86] = (byte)checksum;
        }
        if ((checksum ^= this.readTranslateTable[AppleUtil.getUnsignedByte(dataField[345])]) != 0) {
            return null;
        }
        byte[] sectorData = new byte[256];
        for (int i = 0; i < sectorData.length; ++i) {
            int b1 = AppleUtil.getUnsignedByte(buffer[i]);
            int lowerBits = buffer.length - i % 86 - 1;
            int b2 = AppleUtil.getUnsignedByte(buffer[lowerBits]);
            int shiftPairs = i / 86 * 2;
            int[] reverseValues = new int[]{0, 2, 1, 3};
            int b = b1 << 2 | reverseValues[b2 >> shiftPairs & 3];
            sectorData[i] = (byte)b;
        }
        return sectorData;
    }

    protected int locateField(int byte1, int byte2, int byte3, byte[] trackData, byte[] fieldData, int startingOffset) {
        int i;
        int position = 0;
        for (i = startingOffset; i < trackData.length + fieldData.length; ++i) {
            int offset = i % trackData.length;
            int b = AppleUtil.getUnsignedByte(trackData[offset]);
            if (position == 0 && b == byte1) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position == 1 && b == byte2) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position == 2 && b == byte3) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position >= 3 && position <= fieldData.length) {
                if (position < fieldData.length) {
                    fieldData[position++] = (byte)b;
                }
                if (position != fieldData.length) continue;
                break;
            }
            position = 0;
        }
        return i % trackData.length;
    }

    protected int decodeOddEven(byte[] buffer, int offset) {
        int b1 = AppleUtil.getUnsignedByte(buffer[offset]);
        int b2 = AppleUtil.getUnsignedByte(buffer[offset + 1]);
        return (b1 << 1 | 1) & b2;
    }

    protected void encodeOddEven(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value >> 1 | 0xAA);
        buffer[offset + 1] = (byte)(value | 0xAA);
    }

    @Override
    public void writeSector(int track, int dosSector, byte[] sectorData) throws IllegalArgumentException {
        int sector = sectorInterleave[dosSector];
        byte[] trackData = this.readTrackData(track);
        int offset = 0;
        byte[] addressField = new byte[14];
        boolean found = false;
        while (!found && offset < trackData.length) {
            int nextOffset = this.locateField(213, 170, 150, trackData, addressField, offset);
            if (nextOffset < offset) {
                throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", sector, track, 2));
            }
            offset = nextOffset;
            int t = this.decodeOddEven(addressField, 5);
            int s = this.decodeOddEven(addressField, 7);
            found = t == track && s == sector;
        }
        if (!found) {
            throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", sector, track, 2));
        }
        int[] bb00 = new int[256];
        int[] bc00 = new int[86];
        int x = 0;
        int y = 2;
        while (true) {
            if (--y < 0) {
                y += 256;
            }
            int a = AppleUtil.getUnsignedByte(sectorData[y]);
            int n = x;
            bc00[n] = bc00[n] << 1;
            int n2 = x;
            bc00[n2] = bc00[n2] | a & 1;
            int n3 = x;
            bc00[n3] = bc00[n3] << 1;
            int n4 = x++;
            bc00[n4] = bc00[n4] | (a >>= 1) & 1;
            bb00[y] = a >>= 1;
            if (x < 86) continue;
            x = 0;
            if (y == 0) break;
        }
        x = 0;
        while (x < 86) {
            int n = x++;
            bc00[n] = bc00[n] & 0x3F;
        }
        byte[] diskData = new byte[343];
        int pos = 0;
        for (y = 86; y > 0; --y) {
            diskData[pos++] = y == 86 ? (byte)writeTranslateTable[bc00[y - 1]] : (byte)writeTranslateTable[bc00[y] ^ bc00[y - 1]];
        }
        diskData[pos++] = (byte)writeTranslateTable[bc00[0] ^ bb00[y]];
        for (y = 1; y < 256; ++y) {
            diskData[pos++] = (byte)writeTranslateTable[bb00[y] ^ bb00[y - 1]];
        }
        diskData[pos++] = (byte)writeTranslateTable[bb00[255]];
        byte[] dataFieldPrologue = new byte[3];
        offset = this.locateField(213, 170, 173, trackData, dataFieldPrologue, offset);
        for (int i = 0; i < diskData.length; ++i) {
            pos = (offset + i) % trackData.length;
            trackData[pos] = diskData[i];
        }
        this.writeTrackData(track, trackData);
    }

    @Override
    public int getTracksPerDisk() {
        return 35;
    }

    @Override
    public int getSectorsPerTrack() {
        return 16;
    }

    @Override
    public int getBlocksOnDevice() {
        return 280;
    }

    @Override
    public void format() {
        byte[] diskImage = new byte[232960];
        Arrays.fill(diskImage, (byte)-1);
        this.getDiskImageManager().setDiskImage(diskImage);
        byte[] addressField = new byte[14];
        byte[] dataField = new byte[349];
        Arrays.fill(dataField, (byte)-106);
        byte[] addressPrologue = new byte[]{-43, -86, -106};
        byte[] dataPrologue = new byte[]{-43, -86, -83};
        byte[] epilogue = new byte[]{-34, -86, -21};
        System.arraycopy(addressPrologue, 0, addressField, 0, 3);
        System.arraycopy(epilogue, 0, addressField, 11, 3);
        System.arraycopy(dataPrologue, 0, dataField, 0, 3);
        System.arraycopy(epilogue, 0, dataField, 346, 3);
        int addressSync = 43;
        int dataSync = 10;
        int volume = 254;
        for (int track = 0; track < this.getTracksPerDisk(); ++track) {
            byte[] trackData = this.readTrackData(track);
            int offset = 0;
            for (int sector = 0; sector < this.getSectorsPerTrack(); ++sector) {
                this.encodeOddEven(addressField, 3, volume);
                this.encodeOddEven(addressField, 5, track);
                this.encodeOddEven(addressField, 7, sector);
                this.encodeOddEven(addressField, 9, volume ^ track ^ sector);
                System.arraycopy(addressField, 0, trackData, offset += addressSync, addressField.length);
                offset += addressField.length;
                System.arraycopy(dataField, 0, trackData, offset += dataSync, dataField.length);
                offset += dataField.length;
            }
            this.writeTrackData(track, trackData);
        }
    }
}

